/*
 * Decompiled with CFR 0.152.
 */
package com.anotherera.core;

import com.anotherera.core.ACBFClassTransformer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ACBFModContainer
extends DummyModContainer {
    private FMLEventChannel acbfNetwork;

    public ACBFModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "anothercommonbugfix";
        meta.name = "Another Common Bug Fix";
        meta.version = "1.2.5";
        meta.authorList = Arrays.asList("Is_GK");
        meta.description = "Another Common Bug Fix";
        meta.url = "www.\u26aa\u26aa\u26aa.com";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        if (ACBFClassTransformer.checkFixPacket) {
            NetworkRegistry.INSTANCE.register((ModContainer)this, ((Object)((Object)this)).getClass(), null, evt.getASMHarvestedData());
        }
    }

    @Subscribe
    public void init(FMLPreInitializationEvent event) {
        event.getModLog().info("Another Common Bug Fix Loaded");
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ACBFClassTransformer.checkFixPacket) {
            this.acbfNetwork = NetworkRegistry.INSTANCE.newEventDrivenChannel("checkFixResourceList");
            this.acbfNetwork.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ACBFClassTransformer.checkFixPacket && event.player instanceof EntityPlayerMP) {
            this.acbfNetwork.sendTo(new FMLProxyPacket(new PacketBuffer(Unpooled.buffer()), "checkFixResourceList"), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        FMLProxyPacket packet = event.getPacket();
        if (packet != null && packet.channel().equals("checkFixResourceList")) {
            ByteBuf buffer = packet.payload();
            HashMap clientFixPackets = Maps.newHashMap();
            int fixPacketCount = buffer.readInt();
            for (int i = 0; i < fixPacketCount; ++i) {
                String fixPacketName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                String md5 = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                clientFixPackets.put(fixPacketName, md5);
            }
            HashMap clientEnableTransform = Maps.newHashMap();
            int enableTransformCount = buffer.readInt();
            for (int i = 0; i < fixPacketCount; ++i) {
                String fixPacketName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                String string = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                clientEnableTransform.put(fixPacketName, string);
            }
            ArrayList fieldPacket = Lists.newArrayList();
            for (Map.Entry entry : ACBFClassTransformer.fixPacketsMd5.entrySet()) {
                if (clientFixPackets.containsKey(entry.getKey()) && ((String)clientFixPackets.get(entry.getKey())).equals(entry.getValue())) continue;
                fieldPacket.add(entry.getKey());
            }
            ArrayList fieldTransform = Lists.newArrayList();
            for (Map.Entry<String, String> entry : ACBFClassTransformer.enableTransformMd5.entrySet()) {
                if (clientEnableTransform.containsKey(entry.getKey()) && ((String)clientEnableTransform.get(entry.getKey())).equals(entry.getValue())) continue;
                fieldTransform.add(entry.getKey());
            }
            if (!fieldPacket.isEmpty() || !fieldTransform.isEmpty()) {
                ((NetHandlerPlayServer)event.getHandler()).func_194028_b((ITextComponent)new TextComponentString(String.format("FixPacket rejections %s, Config rejections %s", fieldPacket, fieldTransform)));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (packet != null && packet.channel().equals("checkFixResourceList")) {
            ByteBuf buffer = Unpooled.buffer();
            buffer.writeInt(ACBFClassTransformer.fixPacketsMd5.size());
            for (Map.Entry<String, String> entry : ACBFClassTransformer.fixPacketsMd5.entrySet()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getValue());
            }
            buffer.writeInt(ACBFClassTransformer.enableTransformMd5.size());
            for (Map.Entry<String, String> entry : ACBFClassTransformer.enableTransformMd5.entrySet()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getValue());
            }
            this.acbfNetwork.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "checkFixResourceList"));
        }
    }

    public String toString() {
        return "CoreMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }
}

